% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program PlayMovie
function PlayMovie(movieFile, fromTime, toTime, movieSize, ...
        rate, soundVolume)
% Play movie with sound. Quicktime is needed for this to work.
% Set fromTime and toTime to choose a clip inside a movie 
% clip. movieSize, default 1, controls the ratio between 
% displayed and original movie size. rate, default 1, controls 
% the playback speed. soundVolume (0~1) controls the sound
% volume. Press ESC to stop playing.
 
if nargin < 1 || isempty(movieFile)
    [movieFile pathName] = uigetfile('*.mpeg;*.mpg;*.avi; *.mov', 'Select Movie File');
    if movieFile == 0, return; end
    movieFile = fullfile(pathName, movieFile);
end
 
% Control clip time, size and sound volume
% Set default values if these inputs are not in the argument list
if nargin < 2 || isempty(fromTime), fromTime = 0; end 
if nargin < 3 || isempty(toTime), toTime = inf; end 
if nargin < 4 || isempty(movieSize), movieSize = 1; end  
        % 1 for original
if nargin < 5 || isempty(rate), rate = 1; end 
        % 1 for original
if nargin < 6 || isempty(soundVolume), soundVolume = 1; end  
        % 0 to 1
 
% Open window & movie
if exist('onCleanup', 'class'), oC_Obj = ...
     onCleanup(@()sca); end
        % close pre-existing PsychToolbox screens
whichScreen = max(Screen('screens'));
[windowPtr ScreenRect] = Screen('OpenWindow', whichScreen, 0);
[movie dur fps width height] = Screen('OpenMovie', ...
     windowPtr, movieFile);
Screen('SetMovieTimeIndex', movie, fromTime); 
        % set starting texture image
Screen('PlayMovie', movie, rate, 0, soundVolume); 
        % start to buffer movie
 
% Deal with movie size
movierect = movieSize * [width height];
ratio = max(movierect ./ ScreenRect(3:4));
if ratio > 1, movierect = movierect / ratio; end
movierect = CenterRect([0 0 movierect], ScreenRect);
 
t = Screen('Flip', windowPtr); 
toTime = toTime - fromTime + t; 
        % compute stop time relative to computer time

% Play movie till toTime, or ESC is pressed, 
% or the end of the movie
while t < toTime
    tex = Screen('GetMovieImage', windowPtr, movie); 
        % get a frame
    if tex <= 0 || ~isempty(ReadKey('esc')), break; end 
    Screen('DrawTexture', windowPtr, tex, [], movierect); 
    t = Screen('Flip', windowPtr); 
    Screen('Close', tex);
end
 
%% System Reinstatement Module
 
Screen('PlayMovie', movie, 0); % stop playing
Screen('CloseMovie', movie);   % close the movie
sca;
